#include <avr/io.h>

// konfigurace
#define PAUZA_MEZI_SLOVY	150
#define PAUZA_MEZI_ZNAKY	10
#define PAUZA_MEZI_PIXELY	0
#define TRVANI_PIXELU		6
#define MAXI_VYSKA		1

#define	STRIDANI		0

// PC3
#define LED1_ON	PORTC |= 0x08
#define LED1_OFF	PORTC &= ~0x08

// PC4
#define LED2_ON	PORTC |= 0x10
#define LED2_OFF	PORTC &= ~0x10

// PC5
#define LED3_ON		PORTC |= 0x20
#define LED3_OFF	PORTC &= ~0x20

// PD0
#define LED4_ON		PORTD |= 0x01
#define LED4_OFF	PORTD &= ~0x01

// PD1
#define LED5_ON		PORTD |= 0x02
#define LED5_OFF	PORTD &= ~0x02

// PD2
#define LED6_ON		PORTD |= 0x04
#define LED6_OFF	PORTD &= ~0x04

// PD3
#define LED7_ON		PORTD |= 0x08
#define LED7_OFF	PORTD &= ~0x08

// PD4
#define LED8_ON		PORTD |= 0x10
#define LED8_OFF	PORTD &= ~0x10

// PC2
#define LED9_ON		PORTC |= 0x04
#define LED9_OFF	PORTC &= ~0x04

// PC1
#define LED10_ON	PORTC |= 0x02
#define LED10_OFF	PORTC &= ~0x02

// PC0
#define LED11_ON	PORTC |= 0x01
#define LED11_OFF	PORTC &= ~0x01

// PB2
#define LED12_ON	PORTB |= 0x04
#define LED12_OFF	PORTB &= ~0x04

// PB1
#define LED13_ON	PORTB |= 0x02
#define LED13_OFF	PORTB &= ~0x02

// PB0
#define LED14_ON	PORTB |= 0x01
#define LED14_OFF	PORTB &= ~0x01

// PD7
#define LED15_ON	PORTD |= 0x80
#define LED15_OFF	PORTD &= ~0x80

// PD6
#define LED16_ON	PORTD |= 0x40
#define LED16_OFF	PORTD &= ~0x40

#define ALL_ON PORTD = 255, PORTC = 255, PORTB = 255
#define ALL_OFF PORTD = 0, PORTC = 0, PORTB = 0

unsigned char font[][5] =
{
	// nejnizsi bit je nahore, znaky zleva doprava
	{ 0x7e, 0x11, 0x11, 0x11, 0x7e },
	{ 0x7f, 0x49, 0x49, 0x49, 0x36 },
	{ 0x3e, 0x41, 0x41, 0x41, 0x22 },
	{ 0x7f, 0x41, 0x41, 0x41, 0x3e },
	{ 0x7f, 0x49, 0x49, 0x49, 0x41 },
	{ 0x7f, 0x09, 0x09, 0x09, 0x01 },
	{ 0x3e, 0x41, 0x41, 0x49, 0x7a },
	{ 0x7f, 0x08, 0x08, 0x08, 0x7f },
	{ 0x00, 0x41, 0x7f, 0x41, 0x00 },
	{ 0x20, 0x40, 0x40, 0x40, 0x3f },
	{ 0x7f, 0x08, 0x14, 0x22, 0x41 },
	{ 0x7f, 0x40, 0x40, 0x40, 0x40 },
	{ 0x7f, 0x02, 0x0c, 0x02, 0x7f },
	{ 0x7f, 0x04, 0x08, 0x10, 0x7f },
	{ 0x3e, 0x41, 0x41, 0x41, 0x3e },
	{ 0x7f, 0x09, 0x09, 0x09, 0x06 },
	{ 0x3e, 0x41, 0x61, 0x41, 0xbe },
	{ 0x7f, 0x09, 0x19, 0x29, 0x46 },
	{ 0x26, 0x49, 0x49, 0x49, 0x32 },
	{ 0x01, 0x01, 0x7f, 0x01, 0x01 },
	{ 0x3f, 0x40, 0x40, 0x40, 0x3f },
	{ 0x1f, 0x20, 0x40, 0x20, 0x1f },
	{ 0x3f, 0x40, 0x30, 0x40, 0x3f },
	{ 0x63, 0x14, 0x08, 0x14, 0x63 },
	{ 0x03, 0x04, 0x78, 0x04, 0x03 },
	{ 0x61, 0x51, 0x49, 0x45, 0x43 },
};

void delay(unsigned int ms)
{
	unsigned int i,j;

	for ( j=0; j<100; j++)
		for ( i=0; i<ms; i++);
}

void display(unsigned char ch, unsigned char col)
{
 	ALL_OFF;

	if (MAXI_VYSKA > 0)
	{
		// dvojita vyska 16px
		if(font[ch][col] & 0x01) { LED15_ON; LED16_ON; }
		if(font[ch][col] & 0x02) { LED13_ON; LED14_ON; }
		if(font[ch][col] & 0x04) { LED11_ON; LED12_ON; }
		if(font[ch][col] & 0x08) { LED9_ON; LED10_ON; }
		if(font[ch][col] & 0x10) { LED7_ON; LED8_ON; }
		if(font[ch][col] & 0x20) { LED5_ON; LED6_ON; }
		if(font[ch][col] & 0x40) { LED3_ON; LED4_ON; }
		if(font[ch][col] & 0x80) { LED1_ON; LED2_ON; }
	}
	else
	{
		// normalni vyska 8px
		if(font[ch][col] & 0x01) LED8_ON;
		if(font[ch][col] & 0x02) LED7_ON;
		if(font[ch][col] & 0x04) LED6_ON;
		if(font[ch][col] & 0x08) LED5_ON;
		if(font[ch][col] & 0x10) LED4_ON;
		if(font[ch][col] & 0x20) LED3_ON;
		if(font[ch][col] & 0x40) LED2_ON;
		if(font[ch][col] & 0x80) LED1_ON;
	}
}

void intro (void)
{
	char i,j;
	
	ALL_ON;
	delay (500);
	ALL_OFF;
	delay (2000);
		
	for(i = 0; i < 16; i++)
	{
		for(j = 1; j < 5; j++)
		{
			ALL_OFF;
			switch (j)
			{
				case 1:
					LED4_ON;
					LED8_ON;
					LED12_ON;
					LED16_ON;
					break;
				case 2:
					LED1_ON;
					LED5_ON;
					LED9_ON;
					LED13_ON;
					break;
				case 3:
					LED2_ON;
					LED6_ON;
					LED10_ON;
					LED14_ON;
					break;
				case 4:
					LED3_ON;
					LED7_ON;
					LED11_ON;
					LED15_ON;
					break;
			}
			delay (700);
		}
	}
}

void mezihra (void)
{
	char i,j;
	
	for(i = 0; i < 2; i++)
	{
		for(j = 1; j < 8; j++)
		{
			ALL_OFF;
			switch (j)
			{
				case 1:
					LED1_ON;
					LED16_ON;
					break;
				case 2:
					LED2_ON;
					LED15_ON;
					break;
				case 3:
					LED3_ON;
					LED14_ON;
					break;
				case 4:
					LED4_ON;
					LED13_ON;
					break;
				case 5:
					LED5_ON;
					LED12_ON;
					break;
				case 6:
					LED6_ON;
					LED11_ON;
					break;
				case 7:
					LED7_ON;
					LED10_ON;
					break;
			}
			delay (500);
		}

		for(j = 1; j < 8; j++)
		{
			ALL_OFF;
			switch (j)
			{
				case 7:
					LED2_ON;
					LED15_ON;
					break;
				case 6:
					LED3_ON;
					LED14_ON;
					break;
				case 5:
					LED4_ON;
					LED13_ON;
					break;
				case 4:
					LED5_ON;
					LED12_ON;
					break;
				case 3:
					LED6_ON;
					LED11_ON;
					break;
				case 2:
					LED7_ON;
					LED10_ON;
					break;
				case 1:
					LED8_ON;
					LED9_ON;
					break;
			}
			delay (500);
		}
	}
}

int main(void)
{
	char znak, pixel;
// 	char msg[] = "ORION";
// 	char msg[] = "ZVON";
	char msg[] = "TECHNOPLANETA";
	char delka = strlen(msg);
	unsigned int opakovani;

	// definuju co je vstup (0) a co vystup (1) (plati jen pro ATMEGA8!)
	DDRB = 0x07;	// LED PB0 - PB2
	DDRC = 0x3F;	// LED PC0 - PC5
	DDRD = 0xDF;	// LED vse krome PC5
	
	intro ();

	while(1)
	{
		for (opakovani = 0; opakovani < 200; opakovani++)
		{
			for(znak = 0; znak < delka; znak++)
			{
				for(pixel = 0; pixel < 5; pixel++)
				{
					display(msg[znak] - 'A', pixel);
					delay(TRVANI_PIXELU);
					if (PAUZA_MEZI_PIXELY > 0)
					{
						ALL_OFF;
						delay(PAUZA_MEZI_PIXELY);
					}
				}
				if (PAUZA_MEZI_ZNAKY > 0)
				{
					ALL_OFF;
					delay(PAUZA_MEZI_ZNAKY);
				}
			}
			delay(PAUZA_MEZI_SLOVY);
	
	
			if (STRIDANI > 0)
			{
				for(znak = delka - 1; znak >= 0; znak--)
				{
					for(pixel = 4; pixel >= 0; pixel--)
					{
						display(msg[znak] - 'A', pixel);
						delay(TRVANI_PIXELU);
						if (PAUZA_MEZI_PIXELY > 0)
						{
							ALL_OFF;
							delay(PAUZA_MEZI_PIXELY);
						}
					}
					if (PAUZA_MEZI_ZNAKY > 0)
					{
						ALL_OFF;
						delay(PAUZA_MEZI_ZNAKY);
					}
				}
				delay(PAUZA_MEZI_SLOVY);
			}
		}
		
		// po maximu opakovani mezihra
		mezihra ();
	}
	return 0;
}
